//=============================================================================
// BalloonPathEnd
// This is a trigger monitors the round number and when reaching to TriggerAtRound
// defined it will trigger the event. It can be set to trigger at the beginning or
// at the end of the round. The event can be delayed and an optional message can
// be send to player.
//=============================================================================
class PB_RoundTrigger extends Triggers;

var(PB_RoundTrigger) int	TriggerAtRound;
var(PB_RoundTrigger) bool	bTriggerAtRoundBegin;
var(PB_RoundTrigger) bool 	bTriggerAtRoundEnd;
var(PB_RoundTrigger) int	DelayEventSeconds;
var(PB_RoundTrigger) string	Message;

var float TimePassed;
var bool bTriggered;

function Touch( actor Other )
{
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	SetTimer(0.1,True);
}

function Timer()
{
local Pawn P;
local GRI GRI;
local int NumBalloons;

	GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);
	
	if ( GRI != None )
		{
		if ( bTriggerAtRoundBegin && TriggerAtRound == GRI.Round && !bTriggered && GRI.bRoundStarted )
			{
			if ( DelayEventSeconds > 0 )
				{
				TimePassed += 0.1;
				if ( TimePassed > DelayEventSeconds )
					{
					bTriggered = True;
					TriggerRound();
					}
				}
			else
				{
				bTriggered = True;
				TriggerRound();
				}
			}
		else if ( bTriggerAtRoundEnd && TriggerAtRound == GRI.Round && !bTriggered )
			{
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				{
				if ( P.IsA('Balloon'))
					{
					NumBalloons++;
					}
				}
			if ( NumBalloons == 0)
				{
				if ( DelayEventSeconds > 0 )
					{
					TimePassed += 0.1;
					if ( TimePassed > DelayEventSeconds )
						{
						bTriggered = True;
						TriggerRound();
						}
					}
				else
					{
					bTriggered = True;
					TriggerRound();
					}
				}
			}
		}
		
}

function TriggerRound()
{
local actor A;
local PlayerPawn P,PP;

	foreach AllActors(class 'PlayerPawn', P)
		{
		if( Message != "" )
			P.ClientMessage( Message );
			PP = P;
		}
		
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( PP, PP );
}

defaultproperties
{
     Texture=Texture'PopBalloonsTextures.Editor.RoundTriggerIcon'
	 CollisionRadius=46.000000
     CollisionHeight=50.000000
	 bHidden=True
	 TriggerAtRound=2
	 bTriggerAtRoundBegin=True
	 bTriggerAtRoundEnd=False
	 DelayEventSeconds=0
}
